//+------------------------------------------------------------------+
//|                                            SimpleCandles-xxx.mq5 |
//|                                 Copyright 2024-2026, Yuriy Bykov |
//|                            https://www.mql5.com/ru/users/antekov |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024-2026, Yuriy Bykov"
#property link      "https://www.mql5.com/ru/articles/19684"
#property description "Итоговый советник, объединяющий много экземпляров торговых стратегий:"
#property description " "
#property description "Стратегии открывают позиции после нескольких однонаправленных свечей."
#property description "Открытие происходит в сторону, противоположную направлению предыдущей свечи."
#property description "Позиции закрываются только по SL или TP."
#property version "1.05"

// 1. Определяем константу - признак наличия входных параметров
#define __INPUT_PARAMS__

// 2. Подключаем нужную стратегию
#include "Strategies/SimpleCandlesStrategy.mqh";

// 3. Подключаем шаблон советнника
#include "../Adwizard/Experts/Expert.mqh"

// 4. 
//+------------------------------------------------------------------+
//| Входные параметры                                                |
//+------------------------------------------------------------------+
input group "::: Использовать группу стратегий"
sinput int        groupId_       = 1;     // - ID группы из новой библиотеки (0 - последняя)
sinput bool       useAutoUpdate_ = false; // - Использовать автообновление?

input group "::: Управление капиталом"
sinput double expectedDrawdown_  = 10;    // - Максимальный риск (%)
sinput double fixedBalance_      = 0;     // - Используемый депозит (0 - использовать весь) в валюте счета
input  double scale_             = 1.00;  // - Масштабирующий множитель для группы

input group ":::  Менеджер закрытия"
input bool        cmIsActive_                = true;     // - Активен?
input double      cmStartBaseBalance_        = 100000;   // - Базовый баланс
input ENUM_CM_CALC_LOSS
cmCalcLossLimit_                       = CM_CALC_LOSS_PERCENT_BB; // - Способ расчёта убытка
input double      cmLossLimit_         = 50;                      // - Значение убытка для фиксации
input ENUM_CM_CALC_PROFIT
cmCalcProfitLimit_                     = CM_CALC_PROFIT_PERCENT_BB;  // - Способ расчёта общей прибыли
input double      cmProfitLimit_       = 200;                        // - Значение общей прибыли для фиксации

input group ":::  Риск-менеджер"
input bool        rmIsActive_                = true;     // - Активен?
input double      rmStartBaseBalance_        = 100000;   // - Базовый баланс
input ENUM_RM_CALC_DAILY_LOSS
rmCalcDailyLossLimit_                        = RM_CALC_DAILY_LOSS_PERCENT_DL;       // - Способ расчёта дневного убытка
input double      rmMaxDailyLossLimit_       = 20;                                  // - Значение дневного убытка
input double      rmCloseDailyPart_          = 1.0;                                // - Значение пороговой части дневного убытка
input ENUM_RM_CALC_OVERALL_LOSS
rmCalcOverallLossLimit_                      = RM_CALC_OVERALL_LOSS_PERCENT_HW_BAL; // - Способ расчёта общего убытка
input double      rmMaxOverallLossLimit_     = 40;                                  // - Значение общего убытка
input double      rmCloseOverallPart_        = 1.0;                                 // - Значение пороговой части общего убытка
input ENUM_RM_CALC_OVERALL_PROFIT
rmCalcOverallProfitLimit_                    = RM_CALC_OVERALL_PROFIT_PERCENT_BB;   // - Способ расчёта общей прибыли
input double      rmMaxOverallProfitLimit_   = 400;                                 // - Значение общей прибыли
input int         rmMaxOverallProfitDate_    = 0;                                   // - Предельное время ожидания общей прибыли (дней)

input double      rmMaxRestoreTime_           = 0;                                  // - Время ожидания лучшего входа на просадке
input double      rmLastVirtualProfitFactor_  = 1;                                  // - Множитель начальной лучшей просадки

input group "::: Прочие параметры"
input ulong    magic_            = 1968401;  // - Magic
input bool     useOnlyNewBars_   = true;     // - Работать только на открытии бара
input bool     usePrevState_     = true;     // - Загружать предыдущее состояние

input string   symbolsReplace_   = "";       // - Правила замены символов

//+------------------------------------------------------------------+